<?php

class ControllerPaymentGateline extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('payment/gateline');

        if (method_exists($this->document, 'setTitle'))
            $this->document->setTitle($this->language->get('heading_title'));
        else
            $this->document->title = $this->language->get('heading_title');

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
            
            $this->model_setting_setting->editSetting('gateline', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');

        $data['entry_eshopid'] = $this->language->get('entry_eshopid');
        $data['entry_secret_key'] = $this->language->get('entry_secret_key');
        $data['entry_link'] = $this->language->get('entry_link');
        $data['entry_initialization_password'] = $this->language->get('entry_initialization_password');
        $data['entry_result_url'] = $this->language->get('entry_result_url');

        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_all_zones'] = $this->language->get('text_all_zones');

        $data['entry_order_status_pending'] = $this->language->get('entry_order_status_pending');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_order_status_failed'] = $this->language->get('entry_order_status_failed');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['tab_general'] = $this->language->get('tab_general');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['error_eshop_id'])) {
            $data['error_eshop_id'] = $this->error['error_eshop_id'];
        } else {
            $data['error_eshop_id'] = '';
        }

        if (isset($this->error['secret_key'])) {
            $data['error_secret_key'] = $this->error['secret_key'];
        } else {
            $data['error_secret_key'] = '';
        }

       
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_payment'),
            'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('payment/gateline', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['action'] = $this->url->link('payment/gateline', 'token=' . $this->session->data['token'], 'SSL');

        $data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');


        // Идентификатор сайта
        if (isset($this->request->post['gateline_eshopid'])) {
            $data['gateline_eshopid'] = $this->request->post['gateline_eshopid'];
        } else {
            $data['gateline_eshopid'] = $this->config->get('gateline_eshopid');
        }

        if (isset($this->request->post['gateline_link'])) {
            $data['gateline_link'] = $this->request->post['gateline_link'];
        } else {
            $data['gateline_link'] = $this->config->get('gateline_link');
        }

        //Пароль сайта
        if (isset($this->request->post['gateline_initialization_password'])) {
            $data['gateline_initialization_password'] = $this->request->post['gateline_initialization_password'];
        } else {
            $data['gateline_initialization_password'] = $this->config->get('gateline_initialization_password');
        }

        // URL
        $data['gateline_result_url'] = HTTP_CATALOG . 'index.php?route=payment/gateline/result_payment';

        if (isset($this->request->post['gateline_order_status_pending_id'])) {
            $data['gateline_order_status_pending_id'] = $this->request->post['gateline_order_status_pending_id'];
        } else {
            $data['gateline_order_status_pending_id'] = $this->config->get('gateline_order_status_pending_id');
        }

        if (isset($this->request->post['gateline_order_status_id'])) {
            $data['gateline_order_status_id'] = $this->request->post['gateline_order_status_id'];
        } else {
            $data['gateline_order_status_id'] = $this->config->get('gateline_order_status_id');
        }

        if (isset($this->request->post['gateline_order_status_failed_id'])) {
            $data['gateline_order_status_failed_id'] = $this->request->post['gateline_order_status_failed_id'];
        } else {
            $data['gateline_order_status_failed_id'] = $this->config->get('gateline_order_status_failed_id');
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // if (isset($this->request->post['gateline_geo_zone_id'])) {
        //     $data['gateline_geo_zone_id'] = $this->request->post['gateline_geo_zone_id'];
        // } else {
        //     $data['gateline_geo_zone_id'] = $this->config->get('gateline_geo_zone_id');
        // }

        // $this->load->model('localisation/geo_zone');

        // $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['gateline_status'])) {
            $data['gateline_status'] = $this->request->post['gateline_status'];
        } else {
            $data['gateline_status'] = $this->config->get('gateline_status');
        }

        if (isset($this->request->post['gateline_sort_order'])) {
            $data['gateline_sort_order'] = $this->request->post['gateline_sort_order'];
        } else {
            $data['gateline_sort_order'] = $this->config->get('gateline_sort_order');
        }


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('payment/gateline.tpl', $data));
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'payment/gateline')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['gateline_eshopid']) {
            $this->error['error_eshop_id'] = $this->language->get('error_eshop_id');
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}

?>
